// $Id: CMidiTrack.cpp,v 1.3 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMidiTrack.hpp"
using Exponent::Midi::CMidiTrack;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiTrack, CCountedObject);

//	===========================================================================
CMidiTrack::CMidiTrack() : m_midiChannel(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiTrack);
}

//	===========================================================================
CMidiTrack::~CMidiTrack()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiTrack);
}

//	===========================================================================
void CMidiTrack::addEvent(CMidiEvent *event)
{
	m_events.addElement(event);
}

//	===========================================================================
void CMidiTrack::adjustDeltaTimeBy(const double offset)
{
	for (long i = 0; i < m_events.getArraySize(); i++)
	{
		CMidiEvent *event = m_events.elementAtIndex(i);

		if (event)
		{
			event->setTimeDelta((long)((double)(event->getTimeDelta()) * offset));
		}
	}
}